//
//  TypicalCase1.swift
//  TheCellSellTests
//
//  Created by Russell Gordon on 2025-10-06.
//

import Testing

/*
 • Daytime minutes more than free threshold for both plans
 • Plan A is cheapest
 • All output text exactly as shown
 • Amounts exactly as shown
 */
struct TypicalCase1 {
    
    // Define usage pattern for this test case
    let dayUse = 300
    let eveningUse = 145
    let weekendUse = 50

    @Test func planACost() {
                
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )
        
        #expect(result == 8175)
        
    }

    @Test func planBCost() {
        
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        #expect(result == 8575)
        
    }

    @Test func compareCosts() {
        
        let costForA = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )

        let costForB = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        let result = compareCellPlanCosts(planA: costForA, planB: costForB)
        
        #expect(result == """
            Plan A costs 8175
            Plan B costs 8575
            Plan A is cheapest.
            """)

    }
    
}

/*
 • Daytime minutes more than free threshold for both plans
 • Plan B is cheapest
 */
struct TypicalCase2 {
    
    // Define usage pattern for this test case
    let dayUse = 262
    let eveningUse = 90
    let weekendUse = 10

    @Test func planACost() {
                
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )
        
        #expect(result == 5600)
        
    }

    @Test func planBCost() {
        
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        #expect(result == 3940)
        
    }

    @Test func compareCosts() {
        
        let costForA = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )

        let costForB = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        let result = compareCellPlanCosts(planA: costForA, planB: costForB)
        
        #expect(result == """
            Plan A costs 5600
            Plan B costs 3940
            Plan B is cheapest.
            """)

    }

}

/*
 • Daytime minutes more than free threshold for both plans
 • Plans A and B are same cost
 */
struct TypicalCase3 {
 
    // Define usage pattern for this test case
    let dayUse = 296
    let eveningUse = 140
    let weekendUse = 6

    @Test func planACost() {
                
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )
        
        #expect(result == 7120)
        
    }

    @Test func planBCost() {
        
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        #expect(result == 7120)
        
    }

    @Test func compareCosts() {
        
        let costForA = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )

        let costForB = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        let result = compareCellPlanCosts(planA: costForA, planB: costForB)
        
        #expect(result == """
            Plan A costs 7120
            Plan B costs 7120
            Plans A and B are the same price.
            """)

    }
    
}

/*
 • Daytime minutes less than free threshold for plan B, not plan A
 • Plan A is cheapest
 */
struct TypicalCase4 {
    
    // Define usage pattern for this test case
    let dayUse = 200
    let eveningUse = 150
    let weekendUse = 10

    @Test func planACost() {
                
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )
        
        #expect(result == 4950)
        
    }

    @Test func planBCost() {
        
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        #expect(result == 5500)
        
    }

    @Test func compareCosts() {
        
        let costForA = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )

        let costForB = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        let result = compareCellPlanCosts(planA: costForA, planB: costForB)
        
        #expect(result == """
            Plan A costs 4950
            Plan B costs 5500
            Plan A is cheapest.
            """)

    }
}

/*
 • Daytime minutes less than free threshold for plan B, not plan A
 • Plan B is cheapest
 */
struct TypicalCase5 {
    // Define usage pattern for this test case
    let dayUse = 210
    let eveningUse = 110
    let weekendUse = 70

    @Test func planACost() {
                
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )
        
        #expect(result == 5800)
        
    }

    @Test func planBCost() {
        
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        #expect(result == 5600)
        
    }

    @Test func compareCosts() {
        
        let costForA = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )

        let costForB = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        let result = compareCellPlanCosts(planA: costForA, planB: costForB)
        
        #expect(result == """
            Plan A costs 5800
            Plan B costs 5600
            Plan B is cheapest.
            """)

    }
}

/*
 • Daytime minutes less than free threshold for plan B, not plan A
 • Plans A and B are same cost
 */
struct TypicalCase6 {
    // Define usage pattern for this test case
    let dayUse = 210
    let eveningUse = 130
    let weekendUse = 30

    @Test func planACost() {
                
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )
        
        #expect(result == 5300)
        
    }

    @Test func planBCost() {
        
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        #expect(result == 5300)
        
    }

    @Test func compareCosts() {
        
        let costForA = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )

        let costForB = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        let result = compareCellPlanCosts(planA: costForA, planB: costForB)
        
        #expect(result == """
            Plan A costs 5300
            Plan B costs 5300
            Plans A and B are the same price.
            """)

    }
}

/*
 • Daytime minutes less than free threshold for both plans
 • Plan A is cheapest
 */
struct TypicalCase7 {
    // Define usage pattern for this test case
    let dayUse = 75
    let eveningUse = 30
    let weekendUse = 50

    @Test func planACost() {
                
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )
        
        #expect(result == 1450)
        
    }

    @Test func planBCost() {
        
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        #expect(result == 2300)
        
    }

    @Test func compareCosts() {
        
        let costForA = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )

        let costForB = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        let result = compareCellPlanCosts(planA: costForA, planB: costForB)
        
        #expect(result == """
            Plan A costs 1450
            Plan B costs 2300
            Plan A is cheapest.
            """)

    }
}
