//
//  BoundaryConditions.swift
//  TheCellSell
//
//  Created by Russell Gordon on 2025-10-06.
//

import Testing

/*
 • Zero minutes for all plans
 • Plans A and B are same cost
 */
struct BoundaryCondition1 {
    // Define usage pattern for this test case
    let dayUse = 0
    let eveningUse = 0
    let weekendUse = 0

    @Test func planACost() {
                
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )
        
        #expect(result == 0)
        
    }

    @Test func planBCost() {
        
        let result = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        #expect(result == 0)
        
    }

    @Test func compareCosts() {
        
        let costForA = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planACostStructure
        )

        let costForB = determineCellPlanCostPerMonth(
            dayMinutesUsed: dayUse,
            eveningMinutesUsed: eveningUse,
            weekendMinutesUsed: weekendUse,
            costStructure: planBCostStructure
        )
        
        let result = compareCellPlanCosts(planA: costForA, planB: costForB)
        
        #expect(result == """
            Plan A costs 0
            Plan B costs 0
            Plans A and B are the same price.
            """)

    }
}

/*
 •
 •
 •
 */
struct BoundaryCondition2 {

}

/*
 •
 •
 •
 */
struct BoundaryCondition3 {

}
