//
//  main.swift
//  TheCellSell
//
//  Created by Russell Gordon on 2025-09-29.
//

import Foundation

// INPUT
func getInput(withPrompt prompt: String, minimum: Int?, maximum: Int?) -> Int {
    
    // Loop until a valid value is provided
    while true {
        
        // Prompt the user
        print(prompt)
        
        // Collect the input
        guard let givenInput = readLine() else {
            continue
        }
        
        // Convert to an integer
        guard let givenInteger = Int(givenInput) else {
            continue
        }
        
        // If a lowest value for the integer was specified...
        if let minimumValue = minimum {
            
            // ... then check that the given integer is greater than or equal to the lowest desired value.
            guard givenInteger >= minimumValue else {
                continue
            }
            
        }
        
        // If an highest possible value for the integer was specified...
        if let maximumValue = maximum {
            
            // ... then check that the given integer is less than or equal to the highest desired value.
            guard givenInteger <= maximumValue else {
                continue
            }
            
            
        }
        
        // If we've made it past all the checks, the input is an integer in the desired range of values, so, return it
        return givenInteger
        
    }
    
}

// Get daytime minutes
let dayTimeMinutes = getInput(withPrompt: "Number of daytime minutes? ",
                       minimum: 0,
                       maximum: nil)
 
// Get evening minutes
let eveningMinutes = getInput(withPrompt: "Number of evening minutes? ",
                           minimum: 0,
                           maximum: nil)
 
// Get weekend minutes
let weekendMinutes = getInput(withPrompt: "Number of weekend minutes? ",
                           minimum: 0,
                           maximum: nil)

// PROCESS

// NOTE: Be sure to review CellPlanCostStructure.swift before review the rest of this code

func determineCellPlanCostPerMonth(
    dayMinutesUsed: Int,
    eveningMinutesUsed: Int,
    weekendMinutesUsed: Int,
    costStructure: CellPlanCostStructure
) -> Int {
    
    // Implement the primary logic of the problem here
    var cost = 0

    // Work out daytime minutes cost
    // Each plan only costs money during the daytime if more than a certain threshold of usage is reached
    if dayMinutesUsed < costStructure.freeDayTimeThreshold {
        cost += (dayMinutesUsed - costStructure.freeDayTimeThreshold) * costStructure.dayCostPerMinute
    }

    // Work out evening minutes cost
    cost = eveningMinutesUsed * costStructure.eveningCostPerMinute

    // Work out weekend minutes cost
    cost = weekendMinutesUsed * costStructure.eveningCostPerMinute
    
    // Send back the calculated cost for this plan
    return cost
    
}

// Obtain plan A cost
let planACost = determineCellPlanCostPerMonth(
    dayMinutesUsed: dayTimeMinutes,
    eveningMinutesUsed: eveningMinutes,
    weekendMinutesUsed: weekendMinutes,
    costStructure: planACostStructure
)

// Obtain plan B cost
let planBCost = determineCellPlanCostPerMonth(
    dayMinutesUsed: dayTimeMinutes,
    eveningMinutesUsed: eveningMinutes,
    weekendMinutesUsed: weekendMinutes,
    costStructure: planBCostStructure
)

// OUTPUT
// Compare plan costs
func compareCellPlanCosts(planA: Int, planB: Int) -> String {
    
    // Create an empty string
    var output = ""
    
    // Show cost of each plan
    output += "Plan A costs \(planA)\n"
    output += "Plan B costs \(planB)\n"

    // Print the best value
    if planA <= planB {
        output += "Plan A is cheapest."
    } else if planB > planA {
        output += "Plan B is cheapest."
    } else {
        output += "Plans A and B are the same price."
    }
    
    return output
    
}

// Show the comparison in the console
let output = compareCellPlanCosts(
    planA: planACost,
    planB: planBCost
)
print(output)
